﻿/*
VERSION:		1.4
1.4		Added usage info to header comments
1.3		fixed triggerChildren() and triggerHitChildren()
			added "isHit" param to triggerHitChildren() to allow excluding collision
1.2		use sendEvent()
	
	
WHAT THIS DOES: 
	Enables:  react.to("onPress").then = 
	onPress()  =>  "onPress" event
	This over-writes mouse function-calls to send events instead,  specifically the default MovieClip mouse functions like "onPress"...
	... so that calling those functions will instead send a corresponding event of the same name.
	Therefore,  you must NOT use  onPress = function()  while using this,  or you'll undo the change.
	
	also:
	
	This also manually triggers every child movieClip's mouse functions when appropriate,  so that they continue to work as expected...
	... which makes this compatible with default movieClips,  and compatible with nested copies of itself.
	
	
WHAT IS AFFECTED: 
	onDragOut
	onDragOver
	onMouseMove
	onPress
	onRelease
	onReleaseOutside
	onRollOut
	onRollOver
	
	
NOTE:
	Do not use this if your pseudo-component is going to contain any of your custom components.
	All of their mouse functionality will be disabled if you do.
	
	All default flash components such as "Button" and "List" are not affected for some reason.
	Only your custom components are adversely affected by this.
	
	
USAGE:
	if(!this.addListener)		AsBroadcaster.initialize(this);
	#include "functions/addMouseEvents.as"
	addMouseEvents( this );
*/
#include "sendEvent.as"
addMouseEvents = function( _this )
{
	// _________________________________________________
	// MOUSE EVENTS
	var triggerChildren = function( functName )
	{
		for(var nam in _this)
		{
			if( typeof(_this[nam]) == "movieclip"  &&  _this[nam] != _this )
			{
				_this[nam][functName]();		// call trigger
			}
		}// for:  all children
	}// triggerChildren()
	
	
	
	var triggerHitChildren = function( functName, isHit )
	{
		if(isHit===undefined)		var isHit = true;
		for(var nam in _this)
		{
			if( typeof(_this[nam]) == "movieclip"  &&  _this[nam] != _this )
			{
				if( _this[nam].hitTest(_root._xmouse, _root._ymouse, false) === isHit ){
					var path = _this+"."+nam+"."+functName;
					_this[nam][functName]();		// call trigger
				}
			}
		}// for:  all children
	}// triggerHitChildren()
	
	
	
	_this.onDragOut = function(){
		sendEvent("onDragOut",null,_this);
		//triggerChildren("onDragOut");
		triggerHitChildren("onDragOut", false);
	}// onDragOut()
	_this.onDragOver = function(){
		sendEvent("onDragOver",null,_this);
		triggerHitChildren("onDragOver");
		//triggerChildren("onDragOver");
	}// onDragOver()
	_this.onMouseMove = function(){
		sendEvent("onMouseMove",null,_this);
	}// onMouseMove()
	_this.onPress = function(){
		sendEvent("onPress",null,_this);
		triggerHitChildren("onPress");
	}// onPress()
	_this.onRelease = function(){
		sendEvent("onRelease",null,_this);
		triggerHitChildren("onRelease");
	}// onRelease()
	_this.onReleaseOutside = function(){
		sendEvent("onReleaseOutside",null,_this);
		triggerHitChildren("onReleaseOutside", false);
		//triggerChildren("onReleaseOutside");
	}// onReleaseOutside()
	_this.onRollOut = function(){
		sendEvent("onRollOut",null,_this);
		triggerHitChildren("onRollOut", false);
		//triggerChildren("onRollOut");
	}// onRollOut()
	_this.onRollOver = function(){
		sendEvent("onRollOver",null,_this);
		triggerHitChildren("onRollOver");
		//triggerChildren("onRollOver");
	}// onRollOver()
}// addMouseEvents()